#include <Carbon.h>
#define ITMAX 10000
#define cr .38
#define ci .085
/*
   	Fractale Julia	 v 1.0 X  10/05/02

Fait avec CodeWarrior 7 (CodeWarrior IDE v4.2.5)

Ce programme fonctionne sur MacOS X
Configuration minimum : MacOS 8.6 avec CarbonLib 1.4

  2002 All Rights Reserved to Didier STRAUS

		http://www.Software-DS.com
*/

WindowRef 	gMainWindow;
WindowPtr	theWindow;
Boolean		gSystemIsMacOSX;

void main (void) {
	int i,j,it,largeur=700,hauteur=550,xmin=0,xmax=700,ymin=0,ymax=550;
	double d;
	double zr,zi;
	double zr_1,zi_1;
	const double rmin= -2.,rmax= 1.,imin= -1.,imax= 1.;
	RGBColor theColour;

	InitCursor();
	if (!(theWindow = GetNewCWindow(300,NULL,(WindowPtr)-1))){
		SysBeep(5);
		ExitToShell();
	}
	SetPortWindowPort(theWindow);
	PenSize(1,1);
	
	if (gSystemIsMacOSX==true)
        ShowSheetWindow(theWindow, gMainWindow);
	else
		ShowWindow(theWindow);

	for(j= ymin; j<ymax; j++){
		for(i= xmin; i<xmax; i++){
			zr_1= (double) i / (double) largeur * (rmax-rmin) + rmin;
			zi_1= (double) j / (double) hauteur * (imax-imin) + imin;

			d= 0.;
			for(it= 0; it<ITMAX && d<4.; it++){
				zr= zr_1*zr_1 - zi_1*zi_1;
				zi= 2*zr_1*zi_1;
				zr+= cr;
				zi+= ci;
				d= zr*zr + zi*zi;
				zr_1= zr;
				zi_1= zi;
			}
			if(d<4) {
				ForeColor(blackColor);
				MoveTo(i,j);
				LineTo(i,j);
			}
			else if (it<5)
					ForeColor(greenColor);
				else if (it<25) {
					theColour.red   = 15000;
					theColour.green = 5000;
					theColour.blue  = 60000-(it-6)*4000;
					RGBForeColor(&theColour);
				}
				else if (it<35) {
					ForeColor(yellowColor);
				}
				else
					ForeColor(blueColor);
				
				MoveTo(i,j);
				LineTo(i,j);
		}
		QDFlushPortBuffer(GetWindowPort(FrontWindow()),NULL);
	}

	while (!Button()){}; /* Pause: Attente d'un clic de souris. */
	while (Button()){};
/* 2002 All Rights Reserved to Didier STRAUS  www.Software-DS.com  Software_DS@mac.com */
}
